<?php
namespace Tygh\Api\Entities;

use Tygh\Api\Response;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

class UsergroupsTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Usergroups
     */
    protected $api;

    /**
     * @var integer Installed languages count
     */
    protected $lang_count;

    protected function setUp()
    {
        parent::setUp();

        $this->api = new Usergroups(array(
            'area'                      => 'A',
            'user_id'                   => '1',
            'user_type'                 => 'A',
            'tax_exempt'                => 'N',
            'last_login'                => '1343637055',
            'usergroup_ids'             => array(),
            'order_ids'                 => array(),
            'act_as_user'               => false,
            'this_login'                => 1343652763,
            'password_change_timestamp' => 0,
            'company_id'                => 0,
            'is_root'                   => 'Y',
            'referer'                   => '',
            'ip'                        => '192.168.1.111',
            'first_expire_check'        => false
        ));
    }


    public function triggersProvider()
    {
        return array('all');
    }

    protected function usergroupsDataset()
    {
        return array(
            'usergroups_tmp.xml',
            'usergroup_privileges_tmp.xml',
            'usergroup_descriptions_tmp.xml',
        );
    }

    /**
     * @dataProvider providerIndex()
     * @datasetProvider usergroupsDataset
     */
    public function testIndex($id, $params, $expected_response)
    {
        $this->assertEquals($expected_response, $this->api->index($id, $params));
    }

    public function providerIndex()
    {
        return array(
            array(
                null,
                array(
                    'with_privileges' => true,
                    'include_default' => true
                ),
                array(
                    'status' => Response::STATUS_OK,
                    'data'   => array(
                        4 => array(
                            'usergroup_id' => '4',
                            'status'       => 'A',
                            'type'         => 'A',
                            'usergroup'    => 'Administrator',
                            'privileges'   =>
                                array(
                                    0  => 'change_order_status',
                                    1  => 'create_order',
                                    2  => 'database_maintenance',
                                    3  => 'delete_orders',
                                    4  => 'edit_blocks',
                                    5  => 'edit_files',
                                    6  => 'edit_order',
                                    7  => 'manage_affiliate',
                                    8  => 'manage_cms',
                                    9  => 'manage_currencies',
                                    10 => 'manage_design',
                                    11 => 'manage_discounts',
                                    12 => 'manage_forms',
                                    13 => 'manage_languages',
                                    14 => 'manage_locations',
                                    15 => 'manage_payments',
                                    16 => 'manage_promotions',
                                    17 => 'manage_shipping',
                                    18 => 'manage_sitemap',
                                    19 => 'manage_static_data',
                                    20 => 'manage_storage',
                                    21 => 'manage_taxes',
                                    22 => 'manage_themes',
                                    23 => 'manage_translation',
                                    24 => 'manage_users',
                                    25 => 'update_settings',
                                    26 => 'upgrade_store',
                                    27 => 'view_catalog',
                                    28 => 'view_cms',
                                    29 => 'view_currencies',
                                    30 => 'view_discounts',
                                    31 => 'view_forms',
                                    32 => 'view_languages',
                                    33 => 'view_locations',
                                    34 => 'view_orders',
                                    35 => 'view_payments',
                                    36 => 'view_reports',
                                    37 => 'view_settings',
                                    38 => 'view_shipping',
                                    39 => 'view_static_data',
                                    40 => 'view_taxes',
                                    41 => 'view_usergroups',
                                    42 => 'view_users',
                                ),
                        ),
                        3 => array(
                            'usergroup_id' => '3',
                            'status'       => 'D',
                            'type'         => 'C',
                            'usergroup'    => 'Wholesale',
                        ),
                        0 => array(
                            'usergroup_id' => 0,
                            'status'       => 'A',
                            'type'         => 'C',
                            'usergroup'    => 'All',
                        ),
                        1 => array(
                            'usergroup_id' => 1,
                            'status'       => 'A',
                            'type'         => 'C',
                            'usergroup'    => 'Guest',
                        ),
                        2 => array(
                            'usergroup_id' => 2,
                            'status'       => 'A',
                            'type'         => 'C',
                            'usergroup'    => 'Registered user',
                        ),
                    ),
                )
            ),
            array(
                null,
                array(),
                array(
                    'status' => Response::STATUS_OK,
                    'data'   =>
                        array(
                            4 =>
                                array(
                                    'usergroup_id' => '4',
                                    'status'       => 'A',
                                    'type'         => 'A',
                                    'usergroup'    => 'Administrator',
                                ),
                            3 =>
                                array(
                                    'usergroup_id' => '3',
                                    'status'       => 'D',
                                    'type'         => 'C',
                                    'usergroup'    => 'Wholesale',
                                ),
                        ),
                )
            ),
            array(
                4,
                array(),
                array(
                    'status' => Response::STATUS_OK,
                    'data'   =>
                        array(
                            'usergroup_id' => '4',
                            'status'       => 'A',
                            'type'         => 'A',
                            'usergroup'    => 'Administrator',
                            'privileges'   =>
                                array(
                                    0  => 'change_order_status',
                                    1  => 'create_order',
                                    2  => 'database_maintenance',
                                    3  => 'delete_orders',
                                    4  => 'edit_blocks',
                                    5  => 'edit_files',
                                    6  => 'edit_order',
                                    7  => 'manage_affiliate',
                                    8  => 'manage_cms',
                                    9  => 'manage_currencies',
                                    10 => 'manage_design',
                                    11 => 'manage_discounts',
                                    12 => 'manage_forms',
                                    13 => 'manage_languages',
                                    14 => 'manage_locations',
                                    15 => 'manage_payments',
                                    16 => 'manage_promotions',
                                    17 => 'manage_shipping',
                                    18 => 'manage_sitemap',
                                    19 => 'manage_static_data',
                                    20 => 'manage_storage',
                                    21 => 'manage_taxes',
                                    22 => 'manage_themes',
                                    23 => 'manage_translation',
                                    24 => 'manage_users',
                                    25 => 'update_settings',
                                    26 => 'upgrade_store',
                                    27 => 'view_catalog',
                                    28 => 'view_cms',
                                    29 => 'view_currencies',
                                    30 => 'view_discounts',
                                    31 => 'view_forms',
                                    32 => 'view_languages',
                                    33 => 'view_locations',
                                    34 => 'view_orders',
                                    35 => 'view_payments',
                                    36 => 'view_reports',
                                    37 => 'view_settings',
                                    38 => 'view_shipping',
                                    39 => 'view_static_data',
                                    40 => 'view_taxes',
                                    41 => 'view_usergroups',
                                    42 => 'view_users',
                                ),
                        ),
                )
            ),
            array(
                1,
                array(),
                array(
                    'status' => 200,
                    'data'   =>
                        array(
                            'usergroup_id' => 1,
                            'status'       => 'A',
                            'type'         => 'C',
                            'usergroup'    => 'Guest',
                        ),
                )
            ),
        );
    }


    /**
     * @dataProvider providerDelete()
     * @datasetProvider usergroupsDataset
     * @triggersProvider triggersProvider
     */
    public function testDelete($id, $expected_response, $expected_db_ops)
    {
        $this->assertEquals($expected_response, $this->api->delete($id));
        $this->assertDB($expected_db_ops);
    }

    public function providerDelete()
    {
        return array(
            array(
                3,
                array(
                    'status' => Response::STATUS_NO_CONTENT,
                    'data'   => array()
                ),
                array(
                    'cscart_usergroups'             => array('delete'),
                    'cscart_usergroup_descriptions' => array('delete'),
                )
            ),
            array(
                4,
                array(
                    'status' => Response::STATUS_NO_CONTENT,
                    'data'   => array()
                ),
                array(
                    'cscart_usergroups'             => array('delete'),
                    'cscart_usergroup_descriptions' => array('delete'),
                    'cscart_usergroup_privileges'   => array_fill(0, 43, 'delete'),
                )
            ),
            array(
                100500,
                array(
                    'status' => Response::STATUS_NOT_FOUND
                ),
                array()
            )
        );
    }

    /**
     * @dataProvider providerCreate()
     * @datasetProvider usergroupsDataset
     * @triggersProvider triggersProvider
     */
    public function testCreate($data, $expected_response, $expected_db_ops)
    {
        $this->assertEquals($expected_response, $this->api->create($data));
        $this->assertDB($expected_db_ops);
    }

    public function providerCreate()
    {
        $this->lang_count = sizeof(\Tygh\Languages\Languages::getAll());
        return array(
            array(
                array(
                    'lang_code'  => 'en',
                    'status'     => 'A',
                    'type'       => 'A',
                    'usergroup'  => 'Test usergroup',
                    'privileges' => array('manage_cms', 'edit_order')
                ),
                array(
                    'status' => Response::STATUS_CREATED,
                    'data'   => array('usergroup_id' => 5)
                ),
                array(
                    'cscart_usergroups'             => array('insert'),
                    'cscart_usergroup_descriptions' => array('insert', 'insert'),
                    'cscart_usergroup_privileges'   => array('insert', 'insert')
                )
            ),
            array(
                array(
                    'lang_code'  => 'ru',
                    'status'     => 'A',
                    'type'       => 'C',
                    'usergroup'  => 'Test usergroup',
                    'privileges' => array('manage_cms', 'edit_order')
                ),
                array(
                    'status' => Response::STATUS_CREATED,
                    'data'   => array('usergroup_id' => 5)
                ),
                array(
                    'cscart_usergroups'             => array('insert'),
                    'cscart_usergroup_descriptions' => array('insert', 'insert'),
                )
            ),
            array(
                array(
                    'lang_code'  => 'ru',
                    'status'     => 'A',
                    'type'       => 'C',
                    'usergroup'  => 'Теsт UseЯгрoup',
                    'privileges' => array('manage_cms', 'edit_order')
                ),
                array(
                    'status' => Response::STATUS_CREATED,
                    'data'   => array('usergroup_id' => 5)
                ),
                array(
                    'cscart_usergroups'             => array('insert'),
                    'cscart_usergroup_descriptions' => array('insert', 'insert'),
                )
            ),
        );
    }


    /**
     * @dataProvider providerUpdate()
     * @datasetProvider usergroupsDataset
     * @triggersProvider triggersProvider
     */
    public function testUpdate($id, $data, $expected_response, $expected_db_ops)
    {
        $this->assertEquals($expected_response, $this->api->update($id, $data));
        $this->assertDB($expected_db_ops);
    }

    public function providerUpdate()
    {
        return array(
            array(
                3,
                array(
                    'status'     => 'A',
                    'type'       => 'A',
                    'privileges' => array('view_locations', 'manage_locations', 'create_order'),
                    'usergroup'  => 'Updated'
                ),
                array(
                    'status' => Response::STATUS_OK,
                    'data'   => array('message' => 'OK')
                ),
                array(
                    'cscart_usergroups'             => array('update'),
                    'cscart_usergroup_descriptions' => array('update'),
                    'cscart_usergroup_privileges'   => array_fill(0, 3, 'insert'),
                )
            ),
            array(
                4,
                array(
                    'status'     => 'A',
                    'type'       => 'A',
                    'privileges' => array('view_locations', 'manage_locations', 'create_order'),
                    'usergroup'  => 'Updated'
                ),
                array(
                    'status' => Response::STATUS_OK,
                    'data'   => array('message' => 'OK')
                ),
                array(
                    'cscart_usergroups'             => array('update'),
                    'cscart_usergroup_descriptions' => array('update'),
                    'cscart_usergroup_privileges'   => array_merge(
                        array_fill(0, 43, 'delete'),
                        array_fill(0, 3, 'insert')
                    ),
                )
            ),
        );
    }
}