<?php

use Tygh\Shippings\Shippings;
use Tygh\Registry;

require_once dirname(__FILE__) . '/../../TestUnitDB.php';

class ShippingsTest extends TestUnitDB
{

    public $products = array(
        '4088798008' => array(
            'product_id' => 4,
            'product' => "40\" Class (40.0\" Diag.) LED 5003 Series TV",
            'company_id' => 1,
            'company_status' => 'A',
            'company_name' => "Simtech",
            'amount' => 1,
            'in_stock' => 1,
            'is_edp' => 'N',
            'edp_shipping' => 'N',
            'free_shipping' => 'N',
            'shipping_freight' => 30.00,
            'weight' => 20.00,
            'shipping_params' => array(
                'min_items_in_box' => 1,
                'max_items_in_box' => 5,
                'box_length' => 145,
                'box_width' => 12,
                'box_height' => 34,
            ),
            'price' => 699.99,
            'base_price' => 699.99,
            'original_price' => 699.99,
            'modifiers_price' => 0,
            'subtotal' => 699.99,
            'stored_price' => 'N',
        ),
        '822274303' => array(
            'product_id' => 12,
            'product' => "100g Pants",
            'company_id' => 2,
            'company_status' => 'A',
            'company_name' => "ACME Corp",
            'amount' => 1,
            'in_stock' => 10,
            'is_edp' => 'N',
            'edp_shipping' => 'N',
            'free_shipping' => 'N',
            'shipping_freight' => 0.00,
            'weight' => 0,
            'shipping_params' => array(
                'min_items_in_box' => 1,
                'max_items_in_box' => 2,
                'box_length' => 12,
                'box_width' => 32,
                'box_height' => 12,
            ),
            'price' => 30,
            'base_price' => 30,
            'original_price' => 30,
            'modifiers_price' => 0,
            'subtotal' => 30,
            'stored_price' => 'N',
        ),
        '2944839123' => array(
            'product_id' => 18,
            'product' => "3D Blu-ray Disc™ Player (BD-D7000)",
            'company_id' => 1,
            'company_status' => 'A',
            'company_name' => "Simtech",
            'amount' => 2,
            'in_stock' => 3,
            'is_edp' => 'N',
            'edp_shipping' => 'N',
            'free_shipping' => 'Y',
            'shipping_freight' => 40.00,
            'weight' => 21.00,
            'shipping_params' => array(
                'min_items_in_box' => 0,
                'max_items_in_box' => 0,
                'box_length' => 0,
                'box_width' => 0,
                'box_height' => 0,
            ),
            'price' => 299.99,
            'base_price' => 299.99,
            'original_price' => 299.99,
            'modifiers_price' => 0,
            'subtotal' => 599.98,
            'stored_price' => 'N',
        ),

    );
    public $location = array(
        'country' => "US",
        'state' => "MA",
        'city' => "Boston",
        'zipcode' => "02125",
        'address' => "Boston street",
        'address_2' => false,
        'phone' => "8(800)-000-00-00",
        'address_type' => "residential",
        'firstname' => "John",
        'lastname' => "Doe",
    );

    public static function setUpBeforeClass()
    {
        Registry::set('runtime.company_id', 1);
    }

    protected function dsGeneral()
    {
        return array(
            'shippings.xml',
            'shipping_descriptions.xml',
            'shipping_rates.xml',
            'shipping_services.xml',
            'shipping_service_descriptions.xml',
            'companies.xml',
            'company_descriptions.xml',
            'ult_objects_sharing.xml',
        );
    }

    /**
     * @dataProvider dpGroupProductsList
     * @datasetProvider dsGeneral
     * @registryProvider rpGeneral
     */
    public function testGroupProductsList($products, $location, $expected)
    {
        $actual = Shippings::groupProductsList($products, $location);
        $this->assertEquals($expected, $actual);
    }

    /**
     * @dataProvider dpGetShippingsList
     * @datasetProvider dsGeneral
     */
    public function testGetShippingsList($group, $expected)
    {
        // Remove this code after the test is fixed
        $this->markTestSkipped(
            'This test is probably malfunctioning'
        );

        $actual = Shippings::getShippingsList($group);
        $this->assertEquals($expected, $actual);
    }

    /**
     * @dataProvider dpCalculateRates
     */
    public function testCalculateRates($shippings, $expected)
    {
        // Remove this code after the test is fixed
        $this->markTestSkipped(
            'This test is probably malfunctioning'
        );

        $actual = Shippings::calculateRates($shippings);

        foreach ($expected as $k => $v)
        if (isset($expected[$k]['price']) && isset($actual[$k]['price'])) {
            $this->assertEquals(gettype($expected[$k]['price']), gettype($actual[$k]['price']));
            unset($expected[$k]['price']);
            unset($actual[$k]['price']);
        }

        $this->assertEquals($expected, $actual);
    }

    protected function rpGeneral()
    {
        return array(
            'settings.Company.company_country' => 'US',
            'settings.Company.company_city' => 'Boston',
            'settings.Company.company_address' => '44 Main street',
            'settings.Company.company_state' => 'MA',
            'settings.Company.company_zipcode' => '02116',
        );
    }

    public function dpGroupProductsList()
    {
        return array(

            array(
                $this->products, $this->location,
                array(
                    0 => array(
                        'name' => "Simtech",
                        'company_id' => 1,
                        'products' => array(
                            '4088798008' => $this->products['4088798008'],
                            '2944839123' => $this->products['2944839123'],
                            '822274303' => $this->products['822274303'],
                        ),
                        'package_info' => array(
                            'C' => 729.99,
                            'W' => '20.00',
                            'I' => 2,
                            'packages' => array(
                                '0' => array(
                                    'shipping_params' => array(
                                        'min_items_in_box' => 1,
                                        'max_items_in_box' => 5,
                                        'box_length' => 145,
                                        'box_width' => 12,
                                        'box_height' => 34,
                                    ),
                                    'products' => array(
                                        '4088798008' => 1,
                                    ),
                                    'amount' => 1,
                                    'weight' => 20.0,
                                    'cost' => 699.99,
                                ),
                                '1' => array(
                                    'shipping_params' => array(
                                        'min_items_in_box' => 1,
                                        'max_items_in_box' => 2,
                                        'box_length' => 12,
                                        'box_width' => 32,
                                        'box_height' => 12,
                                    ),
                                    'products' => array(
                                        '822274303' => 1,
                                    ),
                                    'amount' => 1,
                                    'weight' => 0.1,
                                    'cost' => 30,
                                ),
                            ),
                            'origination' => array(
                                'name' => "Simtech",
                                'address' => "44 Main street",
                                'city' => "Boston",
                                'country' => "US",
                                'state' => "MA",
                                'zipcode' => '02116',
                                'phone' => '8(800)-000-00-00',
                                'fax' => '',
                            ),
                            'location' => $this->location,
                            'shipping_freight' => 30.0
                        ),
                        'all_edp_free_shipping' => false,
                        'all_free_shipping' => false,
                        'free_shipping' => false,
                        'shipping_no_required' => false,
                    ),
                ),
            ),

        );
    }

    public function dpGetShippingsList()
    {
        $group = array(
            'name' => "Simtech",
            'company_id' => 1,
            'products' => array(
                '4088798008' => $this->products['4088798008'],
                '2944839123' => $this->products['2944839123'],
            ),
            'package_info' => array(
                'C' => 729.99,
                'W' => 20.00,
                'I' => 2,
                'packages' => array (
                    '0' => array (
                        'shipping_params' => array (
                            'min_items_in_box' => 1,
                            'max_items_in_box' => 5,
                            'box_length' => 145,
                            'box_width' => 12,
                            'box_height' => 34,
                        ),
                        'products' => array (
                            '4088798008' => 1,
                        ),
                        'amount' => 1,
                        'weight' => 20,
                        'cost' => 699.99,
                    ),
                    '1' => array (
                        'shipping_params' => array (
                            'min_items_in_box' => 1,
                            'max_items_in_box' => 2,
                            'box_length' => 12,
                            'box_width' => 32,
                            'box_height' => 12,
                        ),
                        'products' => array (
                            '822274303' => 1,
                        ),
                        'amount' => 1,
                        'weight' => 0.1,
                        'cost' => 30,
                    ),
                ),
                'origination' => array (
                    'name' => "Simtech",
                    'address' => "44 Main street",
                    'city' => "Boston",
                    'country' => "US",
                    'state' => "MA",
                    'zipcode' => 02116,
                    'phone' => "8(800)-000-00-00",
                    'fax' => false,
                ),
                'location' => $this->location,
            ),
        );

        return array(

            array(
                $group,
                array(
                    0 => array(
                        'shipping_id' => '1',
                        'shipping' => "Custom shipping method",
                        'delivery_time' => "3-5 days",
                        'destination' => 'I',
                        'min_weight' => '0.00',
                        'max_weight' => '0.00',
                        'rate_calculation' => 'M',
                        'service_id' => '0',
                        'module' => null,
                        'service_code' => null,
                        'service_params' => array(),
                        'rate_info' => array(
                            'rate_id' => 1,
                            'rate_value' => array(
                                'C' => array(
                                    0 => array(
                                        'value' => 40,
                                        'type' => 'F',
                                    ),
                                    30 => array(
                                        'value' => 10,
                                        'type' => 'F',
                                    ),
                                    50 => array(
                                        'value' => 5,
                                        'type' => 'F',
                                    ),
                                ),
                                'I' => array(
                                    0 => array(
                                        'value' => 23,
                                        'type' => 'F',
                                    ),
                                    10 => array(
                                        'value' => 15,
                                        'type' => 'F',
                                    ),
                                ),
                            ),
                        ),
                    ),
                    1 => array(
                        'shipping_id' => '3',
                        'shipping' => "FedEx 2nd day",
                        'delivery_time' => "2 days",
                        'destination' => 'I',
                        'min_weight' => '0.00',
                        'max_weight' => '0.00',
                        'rate_calculation' => 'R',
                        'service_id' => '213',
                        'module' => 'fedex',
                        'service_code' => 'FEDEX_2_DAY',
                        'service_params' => array(
                            'user_key' => '',
                            'user_key_password' => '',
                            'account_number' => '',
                            'meter_number' => '',
                            'test_mode' => 'Y',
                            'package_type' => 'YOUR_PACKAGING',
                            'drop_off_type' => 'REGULAR_PICKUP',
                            'max_weight_of_box' => '0',
                            'height' => '10',
                            'width' => '10',
                            'length' => '10',
                        ),
                        'rate_info' => array(),
                    ),
                ),
            ),

        );
    }

    public function dpCalculateRates()
    {
        $packages = array(
            'C' => 729.99,
            'W' => 20.00,
            'I' => 2,
            'packages' => array (
                0 => array (
                    'shipping_params' => array (
                        'min_items_in_box' => 1,
                        'max_items_in_box' => 5,
                        'box_length' => 145,
                        'box_width' => 12,
                        'box_height' => 34,
                    ),
                    'products' => array (
                        '4088798008' => 1,
                    ),
                    'amount' => 1,
                    'weight' => 20,
                    'cost' => 699.99,
                ),
                1 => array (
                    'shipping_params' => array (
                        'min_items_in_box' => 1,
                        'max_items_in_box' => 2,
                        'box_length' => 12,
                        'box_width' => 32,
                        'box_height' => 12,
                    ),
                    'products' => array (
                        '822274303' => 1,
                    ),
                    'amount' => 1,
                    'weight' => 0.1,
                    'cost' => 30,
                ),
            ),
            'origination' => array (
                'name' => "Simtech",
                'address' => "44 Main street",
                'city' => "Boston",
                'country' => "US",
                'state' => "MA",
                'zipcode' => '02116',
                'phone' => "8(800)-000-00-00",
                'fax' => false,
            ),
            'location' => $this->location,
        );

        $shippings = array(
            0 => array(
                'shipping_id' => 1,
                'shipping' => "Custom shipping method",
                'delivery_time' => "3-5 days",
                'destination' => 'I',
                'min_weight' => 0.00,
                'max_weight' => 0.00,
                'rate_calculation' => 'M',
                'service_id' => 0,
                'params' => array(),
                'rate_info' => array(
                    'rate_id' => 1,
                    'rate_value' => array(
                        'C' => array(
                            0 => array(
                                'value' => 40,
                                'type' => 'F',
                            ),
                            30 => array(
                                'value' => 10,
                                'type' => 'F',
                            ),
                            50 => array(
                                'value' => 5,
                                'type' => 'F',
                            ),
                        ),
                        'I' => array(
                            0 => array(
                                'value' => 23,
                                'type' => 'F',
                            ),
                            10 => array(
                                'value' => 15,
                                'type' => 'F',
                            ),
                        ),
                    ),
                ),
                'package_info' => $packages,
                'keys' => array(
                    'group_key' => 0,
                    'shipping_key' => 0,
                ),
            ),
            1 => array(
                'shipping_id' => 3,
                'shipping' => "FedEx 2nd day",
                'delivery_time' => "2 days",
                'destination' => 'I',
                'min_weight' => 0.00,
                'max_weight' => 0.00,
                'rate_calculation' => 'R',
                'service_id' => 213,
                'service_code' => 'FEDEX_2_DAY',
                'module' => 'fedex',
                'service_params' => array(
                    'user_key' => 'JAHR7R8oMgMFRH55',
                    'user_key_password' => 'YxIJQaZt7Qx3Qt904ibYPhuDa',
                    'account_number' => '510087089',
                    'meter_number' => '118530569',
                    'test_mode' => 'Y',
                    'package_type' => 'FEDEX_BOX',
                    'drop_off_type' => 'REGULAR_PICKUP',
                    'max_weight_of_box' => 0,
                    'height' => 10,
                    'width' => 10,
                    'length' => 10,
                ),
                'rate_info' => array(
                    'rate_id' => 46,
                    'rate_value' => array(
                        'C' => array(
                            0 => array(
                                'value' => 10.00,
                                'type' => 'P',
                            ),
                        ),
                    ),
                ),
                'package_info' => $packages,
                'keys' => array(
                    'group_key' => 0,
                    'shipping_key' => 1,
                ),
            ),
        );

        return array(

            array(
                $shippings,
                array(
                    0 => array(
                        'price' => 51.41,
                        'keys' => array(
                            'group_key' => 0,
                            'shipping_key' => 1,
                        ),
                        'error' => false,
                    ),
                    1 => array(
                        'price' => 28.00,
                        'keys' => array(
                            'group_key' => 0,
                            'shipping_key' => 0,
                        ),
                    ),
                ),
            ),

        );
    }

}
