<?php
require_once dirname(__FILE__) . '/../../TestUnitDB.php';

use Tygh\Less;

class LessTest extends TestUnitDB
{

    /**
     * @dataProvider getParseUrlsTestData
     */
    public function testParseUrls($from_path, $to_path, $input_css, $expected_css)
    {
        $this->assertEquals($expected_css, Less::parseUrls($input_css, $from_path, $to_path));
    }

    public function getParseUrlsTestData()
    {
        $time = TIME;
        return array(
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                'background: url("../media/images/picker_bg_outside.png") repeat-x 0 -50% scroll #000;',
                "background: url('../../../../../../../../design/themes/responsive/media/images/picker_bg_outside.png?{$time}') repeat-x 0 -50% scroll #000;"
            ),
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                "src:url('../media/fonts/glyphs.eot?#iefix') format('embedded-opentype')",
                "src:url('../../../../../../../../design/themes/responsive/media/fonts/glyphs.eot?{$time}#iefix') format('embedded-opentype')"
            ),
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                "src:url('http://yandex.ru/image.png?#')",
                "src:url('http://yandex.ru/image.png?#')",
            ),
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                "src:url('picker.png')",
                "src:url('../../../../../../../../design/themes/responsive/media/picker.png?{$time}')",
            ),
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                "src:url('../customer_screenshot.png')",
                "src:url('../../../../../../../../design/themes/responsive/media/../customer_screenshot.png?{$time}')",
            ),
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                'background: url("data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7");',
                'background: url("data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7");',
            ),
            array(
                '/var/www/cscart.dev/var/cache/misc/statics/design/themes/responsive/css',
                '/var/www/cscart.dev/design/themes/responsive/media',
                "background: url('data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7');",
                "background: url('data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7');",
            ),
        );
    }
}