<?php
require_once dirname(__FILE__) . '/../../TestUnitDB.php';

use Tygh\Api\Response;
use Tygh\Languages\Languages;

/**
 * Tests \Tygh\Languages\Languages
 */
class LanguagesTest extends TestUnitDB
{

    protected function setUp()
    {
        parent::setUp();
    }

    protected function tearDown()
    {
    }

    public static function setUpBeforeClass()
    {
        \Tygh\Registry::set('runtime.company_id', 0);
    }

    protected function languagesDataset()
    {
        $data = array(
            'languages.xml',
        );

        if (fn_allowed_for('ULTIMATE')) {
            $data[] = 'ult_objects_sharing_1.xml';
        }

        return $data;
    }

    /**
     *
     * @dataProvider providerGetAll()
     * @datasetProvider languagesDataset
     */
    public function testGetAll($result)
    {
        $this->assertEquals(Languages::getAll(), $result);
    }

    public function providerGetAll()
    {
        return array(
            // Get languages list
            array(
                array(
                    'en' => array(
                        'lang_id' => 1,
                        'lang_code' => 'en',
                        'name' => 'English',
                        'status' => 'A',
                        'country_code' => 'US',
                    ),
                    'ru' => array(
                        'lang_id' => 2,
                        'lang_code' => 'ru',
                        'name' => 'Russian',
                        'status' => 'A',
                        'country_code' => 'RU',
                    ),
                ),
            ),
        );
    }

    /**
     * @datasetProvider languagesDataset
     */
    public function testUpdate()
    {
        $params = array(
            'lang_code' => 'EN',
            'name' => 'English New',
            'status' => 'H',
            'country_code' => 'RU',
        );

        Languages::update($params, 1);
        $updated = Languages::getAll();
        $params['lang_id'] = 1;

        $this->assertEquals($params, $updated['EN']);
    }

    /**
     * @datasetProvider languagesDataset
     */
    public function testDelete()
    {
        $lang = array(
            'en' => array(
                'lang_id' => '1',
                'lang_code' => 'en',
                'name' => 'English',
                'status' => 'A',
                'country_code' => 'US',
            )
        );

        Languages::deleteLanguages(2);
        $exist = Languages::getAll();

        $this->assertEquals($lang, $exist);
    }

    /**
     * @datasetProvider languagesDataset
     */
    public function testSaveLanguagesIntegrity()
    {
        $this->assertTrue(Languages::saveLanguagesIntegrity());
    }

    /**
     * @datasetProvider languagesDataset
     */
    public function testGetActive()
    {
        $data = array(
            'en' => array(
                'lang_code' => 'en',
                'name' => 'English',
                'status' => 'A',
                'country_code' => 'US',
            ),

            'ru' => array(
                'lang_code' => 'ru',
                'name' => 'Russian',
                'status' => 'A',
                'country_code' => 'RU'
            ),

        );

        $this->assertEquals(Languages::getActive(), $data);
    }

    /**
     * @datasetProvider languagesDataset
     */
    public function testGetSimpleLanguages()
    {
        $data = array(
            'en' => 'English',
            'ru' => 'Russian',
        );

        $this->assertEquals(Languages::getSimpleLanguages(), $data);
    }
}
