<?php

use Tygh\Api\Formats\Text;
define('DIR_ROOT', dirname(__FILE__) . '/../../../../../');
define('AREA', 'A');

require dirname(__FILE__) . '/../../../../../app/functions/fn.common.php';
require dirname(__FILE__) . '/../../../../../app/Tygh/Api/IFormat.php';
require dirname(__FILE__) . '/../../../../../app/Tygh/Api/Formats/Text.php';

/**
 * Tests core API functionality via CURL
 */
class Api_Formats_TextTest extends PHPUnit_Framework_TestCase
{
    protected $_object;

    protected function setUp()
    {
        parent::setUp();

        $this->_object = new Text();
    }

    protected function tearDown()
    {
    }

    /**
     * @dataProvider providerDecode()
     */
    public function testDecode($data, $result)
    {
        $this->assertEquals($this->_object->decode($data), $result);
    }

    public function providerDecode()
    {
        return array(
            array('a', array('a' => '')),
            array('a=2&s=4', array('a' => '2', 's' => '4')),
            array('a=2&s=4&b[]=3&b[5]=4', array('a' => '2','s' => '4','b' => array(0 => '3', 5 => '4'),)),
        );
    }
}
