<?php
namespace Tygh\Api\Entities;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

use Tygh\Api\Entities\Languages;
use Tygh\Api\Response;
/**
 * Tests core API functionality via CURL
 */
class AuthTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Auth
     */
    protected $api_auth;

    protected function setUp()
    {
        parent::setUp();

        $this->api_auth = new Auth(array(
            'area' => 'A',
            'user_id' => '1',
            'user_type' => 'A',
            'tax_exempt' => 'N',
            'last_login' => '1343637055',
            'usergroup_ids' => array ( ),
            'order_ids' => array ( ),
            'act_as_user' => false,
            'this_login' => 1343652763,
            'password_change_timestamp' => 0,
            'company_id' => 0,
            'is_root' => 'Y',
            'referer' => '',
            'ip' => '192.168.1.111',
            'first_expire_check' => false
        ));

    }

    protected function tearDown()
    {
    }

    /**
     *
     * @dataProvider providerIndex()
     */
    public function testIndex($result)
    {
        $actual = $this->api_auth->index();
        $this->assertEquals($result, $actual);
    }

    public function providerIndex()
    {
        return array(
            array(array(
                'status' => Response::STATUS_METHOD_NOT_ALLOWED,
                'data' => array(),
            )),
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     */
    public function testCreate($params, $result)
    {
        $actual = $this->api_auth->create($params);

        if ($actual['status'] == Response::STATUS_CREATED) {
            $this->assertNotEmpty($actual['data']['key']);
            $this->assertNotEmpty($actual['data']['link']);
        } else {
            $this->assertEquals($result, $actual);
        }
    }

    public function providerCreate()
    {
        return array(
            // Try create with empty data
            array(array(), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(),
            )),
            // Try create non-existing user key
            array(array(
                'email' => 'email@email',
                ),
                array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            array(array(
                'email' => 'admin@example.com',
                ),
                array(
                    'status' => Response::STATUS_CREATED,
                    'data' => array(),
                )),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     */
    public function testUpdate($id, $params, $result)
    {
        $actual = $this->api_auth->update($id, $params);
        $this->assertEquals($result, $actual);
    }

    public function providerUpdate()
    {
        return array(
            array(1, array(), array(
                'status' => Response::STATUS_METHOD_NOT_ALLOWED,
                'data' => array(),
            )),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     */
    public function testDelete($id, $result)
    {
        $actual = $this->api_auth->delete($id);
        $this->assertEquals($result, $actual);

    }

    public function providerDelete()
    {
        return array(
            array(1, array(
                'status' => Response::STATUS_METHOD_NOT_ALLOWED,
                'data' => array(),
            )),
        );
    }
}
